﻿using System;
using System.Data;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Web;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessManager.TBI;
using VeteransAffairs.Registries.BusinessManager.MDWS; // Add 29-Oct-2010 per JH
using System.Text;
using System.Runtime.InteropServices;
using Telerik.Web.UI;

public partial class TBI_Instruments_OptimalFollowUp : BaseTBIInstrumentPage
{

    #region Variable Declarations
    private const string FailedFormValuesName = "OptimalFollowUpFailedFormValues";
    private const string DeferredMessageKeyName = "OptimalFollowUpDeferredMessageKey";
    private const int _surveyTypeId = 35; // Database Id for MPAI 
    PatientManager patientManager = new PatientManager();
    InstrumentType instrumentType = new InstrumentType();
    private bool _autoSaved = false;

    SURVEY _survey;   // the root object in the Survey set
    SURVEY_RESULT _surveyResult; // the object representing the actual data in the Survey

    protected List<string> _oneAnswers, _FiveDFiveAAnswers;

    List<STD_QUESTION> QuestionList = new List<STD_QUESTION>();

    #endregion

    /// <summary>
    /// Default Constructor
    /// </summary>
    public TBI_Instruments_OptimalFollowUp()
    {
        //Manager Save Notification Event Handler
        patientManager.BOSaveSuccess += manager_BOSaveSuccess;
    }

    #region Protected Methods

    /// <summary>
    /// Page Load Method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        TBIServiceTO _tbiServiceTo;
        try
        {
            // confirm instrument is active - if not, a redirect will occur.
            this.CheckActiveStatus(_surveyTypeId);

            _oneAnswers = new List<string>(10);
            _FiveDFiveAAnswers = new List<string>(8);

            _tbiServiceTo = (TBIServiceTO)Session["TBIServiceTO"];
            _tbiInstrumentManager.TbiServiceTo = _tbiServiceTo;

            string instTitle = _tbiInstrumentManager.GetInstrumentByID(_surveyTypeId).Name;

            LabelBreadCrumb.Text = "TBI Instruments > Instrument Associations > " + instTitle;
            LabelInstrumentTitle.Text = instTitle;
            Page.Title = "TBI Instruments - " + instTitle;

            if (_tbiInstrumentManager.TbiServiceTo != null)
            {
                Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
                labelUser.Text = _tbiInstrumentManager.TbiServiceTo.UserName;

                LabelPatient.Text = _tbiInstrumentManager.TbiServiceTo.PatientName;
                LabelSSN.Text = _tbiInstrumentManager.TbiServiceTo.PatientSnum;
            }
        }
        catch (Exception ex)
        {
            //Redirect to message that session is ended and need to log back in from CPRS.
            Exception _tbilogerror = HandleTBIException(ex, "OptimalFollowUp.aspx", "100027", "SESSIOENDED");
            Response.Redirect("Warning.aspx?err=2", false);
        }

        if (!IsPostBack)
        {
            if (instrumentType.Status != null)
            {
                _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType = instrumentType;
            }
            string _snum = "";
            if (_tbiInstrumentManager.TbiServiceTo != null)
            {
                _snum = _tbiInstrumentManager.TbiServiceTo.PatientSnum;
            }

            if (!string.IsNullOrEmpty(_snum))
            {
                string patICN = patientManager.GetPatientICNBySnum(_snum);   //DEBUG(ETM) Look at this was using GetPatientICNBySSN

                if (!string.IsNullOrEmpty(patICN))
                {
                    ViewState["PatientICN"] = patICN;
                    RefreshSurvey(patICN);
                }
                else
                {
                    throw new ArgumentException("Patient with this SSN does not exist.");
                }

                if (_survey != null && !_survey.isNew)
                {
                    SetUpSurvey(_survey);
                }
                string referrer = "";
                if (Request.UrlReferrer != null)
                {
                    referrer = Request.UrlReferrer.PathAndQuery;
                }
                ViewState["referrer"] = referrer;
            }

            //Check if the request is to start a new item 
            //a new item page request is signified when the querystring parameter id equals zero or is not present
            if (_tbiInstrumentManager.TbiServiceTo == null)
            {
                Logging.WriteLogToFile("Optimal.Page_Load(): WarningRedirect: _tbiInstrumentManager.TbiServiceTo == null");
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }
            else
            {
                LabelPatient.Text = _tbiInstrumentManager.TbiServiceTo.PatientName;
                string _SSN = _tbiInstrumentManager.TbiServiceTo.PatientSnum.Trim().Length == 9 ? String.Format("{0:000-00-0000}", int.Parse(_tbiInstrumentManager.TbiServiceTo.PatientSnum)) : _tbiInstrumentManager.TbiServiceTo.PatientSnum;
                //LabelFacility.Text = _tbiInstrumentManager.TbiServiceTo.InstitutionName;
                LabelSSN.Text = "*****" + _SSN.Substring(7, 4);
            }
        }

        QuestionList = GetAllQuestionsForSurvey();
        // Set control values for Diagnosis Question

        dpDate1.MaxDate = DateTime.Now;
        setUpRadioButtons(pnlBaselineDifficulty, _survey);

    }
    
    bool preventNotification = false;

    protected void Page_Init(object sender, EventArgs e)
    {
        selectedInstrumentType = _tbiInstrumentManager.GetInstrumentByID(_surveyTypeId);
        VeteransAffairs.Registries.QuestionChoiceRetriever.Reset(_tbiInstrumentManager, _surveyTypeId);
    }
    
    private InstrumentType selectedInstrumentType;

    protected void Page_Unload(object sender, EventArgs e)
    {
        VeteransAffairs.Registries.QuestionChoiceRetriever.Reset(null, -1);
    }
    
    protected void Page_PreRenderComplete(object sender, EventArgs e)
    {
        Dictionary<string, string> cache;
        preventNotification = Request.UrlReferrer.ToString().Contains("InstrumentSummaryNote");
        if (preventNotification != true)
        {
            if (!Page.IsPostBack && Helpers.SetupPageFromCache(this, FailedFormValuesName, out cache))
            {
                SuppressSaveMessage = false;
                SaveFailMessage = "Unable to save the survey.\r\n\r\nThere may be network issues preventing you from saving.\r\n\r\nPlease try to submit your changes again.";
                RenderStartUpMessage(false);
            }
            else if (Page.IsPostBack && !preventNotification)
            {
                DeferredMessage = "Save was Successful!";
                if ( _autoSaved == true )
                {
                    DeferredMessage="Auto-Save was Successful!";
                }
            }
            else if (DeferredMessage != null)
            {
                SuppressSaveMessage = false;
                SaveSuccessMessage = DeferredMessage;
                RenderStartUpMessage(true);
                DeferredMessage = null;
            }
        }
    }
    protected override void OnPreRender(EventArgs e)
    {
        base.OnPreRender(e);
    }

    private static string DeferredMessage
    {
        get { return HttpContext.Current.Session[DeferredMessageKeyName] as string; }
        set { HttpContext.Current.Session[DeferredMessageKeyName] = value; }
    }

    protected override void LoadViewState(object savedState)
    {
        base.LoadViewState(savedState);
        string surveyXml = (string)ViewState["surveyXml"];
        _survey = SerializerUtil.Deserialize<SURVEY>(surveyXml);

    }

    protected override object SaveViewState()
    {
        ViewState["surveyXml"] = _survey.Serialize();
        return base.SaveViewState();
    }

    /// <summary>
    /// Returns the Question_Text of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected string GetQuestionText(string questionId)
    {
        foreach (STD_QUESTION ques in QuestionList)
        {
            if (ques.QUESTION_NUMBER.ToLower() == questionId.ToLower())
            {
                //Replace("Follow Up Difficulty-", "rblQdifficulty");
                return ques.QUESTION_NUMBER.ToLower().ToString().Replace("follow up difficulty-", "") + ". " + ques.QUESTION_TEXT;
            }
        }

        return "";
    }

    /// <summary>
    /// Returns the Question_Id of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected int GetQuestionId(string questionNumber)
    {
        foreach (STD_QUESTION ques in QuestionList)
        {
            if (ques.QUESTION_NUMBER.ToLower() == questionNumber.ToLower())
            {
                return ques.ID;
            }
        }

        return 0;
    }

    /// <summary>
    /// Save Draft button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    public void btnSaveSurveyDraft_Click(object sender, EventArgs e)
    {
        Int32 status = 0;
        SaveFailMessage = "Save Succeeded";
        SaveCompleteSurvey(ref status);
        Response.Redirect(Request.Url.PathAndQuery, false);
    }

    /// <summary>
    /// Save and Prepare Note button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        try
        {
            if (Page.IsValid)
            {
                Int32 status = 0;
                SaveFailMessage = "Save Successful";
                SaveCompleteSurvey(ref status);
                if (status > 0)
                {
                    preventNotification = true;
                    Session["survey"] = _survey;
                    Response.Redirect("InstrumentSummaryNote.aspx", false);
                }
                else
                {
                    Response.Redirect(Request.Url.PathAndQuery, false);
                }
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "OptimalFollowUp.aspx", "100030", "btnSubmit_Click()");
        }
    }

    /// <summary>
    /// Inactive timer firing.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void InActiveTimer_Tick(object sender, EventArgs e)
    {
        _autoSaved = true;
        Int32 status = 0;
        SaveCompleteSurvey(ref status);
        Response.Redirect(Request.Url.PathAndQuery, false);
    }

    /// <summary>
    /// Cancel button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        ViewState["surveyXml"] = null;
        ViewState["PatientICN"] = null;
        ViewState["referrer"] = null;
        Session.Remove("survey");
        Response.Redirect("Instrument.aspx", false);
        //this.ClientScript.RegisterStartupScript(typeof(Page), "closePage", "<script type='text/javascript'> window.open('','_self','');window.close(); </script>");
    }

    /// <summary>
    /// Fired when scoring is updated.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void updateTotals(object sender, EventArgs e)
    {
        calculateTotals();
    }

    #endregion

    #region Private Methods

    /// <summary>
    /// Get all questions for this survey
    /// </summary>
    /// <returns></returns>
    private List<STD_QUESTION> GetAllQuestionsForSurvey()
    {
        return _tbiInstrumentManager.SelectAllQuestions(_surveyTypeId).ToList();
    }

    /// <summary>
    /// Refresh Survey
    /// </summary>
    /// <param name="patientICN"></param>
    private void RefreshSurvey(string patientICN)
    {
        var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

        if (surveys.Count > 0)
        {
            //SetUpSurvey(_survey);
            _survey = surveys.First();
        }
        else
        {
            _survey = new SURVEY();
        }

        _survey.SetAsChangeTrackingRoot();
    }

    /// <summary>
    /// Save Complete Survey
    /// </summary>
    /// <param name="status"></param>
    private void SaveCompleteSurvey(ref Int32 status)
    {
        calculateTotals();
        string patientICN = String.Empty;
        status = 0;

        //Retrieve patient's ICN from the session variable
        if (ViewState["PatientICN"] != null)
        {
            patientICN = ViewState["PatientICN"].ToString();
            if (String.IsNullOrEmpty(patientICN.Trim()))
            {
                Logging.WriteLogToFile("Optimal.SaveCompletedSurvey(): WarningRedirect: String.IsNullOrEmpty(patientICN.Trim()");
                //Lost state. Redirect to message that need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2", false);
            }
        }
        else
        {
            Logging.WriteLogToFile("Optimal.SaveCompletedSurvey(): WarningRedirect: ViewState[PatientICN] != null");
            //Lost state. Redirect to message that need to log back in from CPRS.
            Response.Redirect("Warning.aspx?err=2");
        }

        if (_survey != null)
        {
            if (_survey.isNew)
            {
                //Ensure that a concurrent session hasn't already inserted a record for this survey
                var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();
                if (surveys.Count > 0)
                {
                    Logging.WriteLogToFile("Optimal.SaveCompletedSurvey(): WarningRedirect: surveys.Count > 0");
                    //A concurrent session has already inserted a record for this survey and it is not new anymore.
                    Response.Redirect("Warning.aspx?err=9", false);
                }
                else
                {
                    _survey.SURVEY_STATUS = "inprocess";
                    _survey.SetAsInsertOnSubmit();
                    _survey.patient_ICN = patientICN;
                    _survey.STD_SURVEY_TYPE_ID = _surveyTypeId;

                    // TODO: change to datepicker
                    _survey.SURVEY_DATE = DateTime.Today;

                    //Save survey if it's new before adding any responses
                    SuppressSaveMessage = true;
                    _tbiInstrumentManager.Update(_survey);
                    SuppressSaveMessage = false;
                    RefreshSurvey(patientICN);
                }
            }
            SaveSurvey(ref _survey);
            _survey.SetAsUpdateOnSubmit();
            status = _tbiInstrumentManager.Update(_survey);

            ((RegistryInstrumentMaster)Master).SetDirtyFlag(false);

            RefreshSurvey(patientICN);
            SuppressSaveMessage = false;
        }
    }

    /// <summary>
    /// Save survey.
    /// </summary>
    /// <param name="survey"></param>
    /// 
    private void SaveSurvey(ref SURVEY survey)
    {
        //first, mark all current answers for deletion
        survey.SetAsChangeTrackingRoot();
        foreach (SURVEY_RESULT tempResult in survey.SURVEY_RESULTs)
            tempResult.SetAsDeleteOnSubmit();

        //Save pnlBaselineDifficulty
        SaveRadBtnListAnswers(pnlBaselineDifficulty, survey);
        try
        {
            // Follow Up Date
            _surveyResult = new SURVEY_RESULT();

            string varID = Helpers.getChoiceID("Optimal Follow Up","Total Score", _tbiInstrumentManager);

            if (!(string.IsNullOrEmpty(varID)))
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(varID);
                _surveyResult.RESULT_TEXT = lblBasicActivitiesScore.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "RehabFollowUp.aspx", "100027", "SaveSurvey() - Rehabilitation Setting");
        }
        try
        {
            // Follow Up Date
            _surveyResult = new SURVEY_RESULT();

            string varID = Helpers.getChoiceID("Optimal Follow Up", "Survey Date", _tbiInstrumentManager);

            if (!(string.IsNullOrEmpty(varID)))
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(varID);
                _surveyResult.RESULT_TEXT = dpDate1.MaxDate.ToString();
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "RehabFollowUp.aspx", "100027", "SaveSurvey() - Rehabilitation Setting");
        }

    }// END SaveSurvey

    private void setUpRadioButtons(Panel panel, SURVEY survey)
    {
        String _sControlID = "";
        try
        {
            foreach (var sResult in survey.SURVEY_RESULTs)
            {
                String s = sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER;
                if (s.Contains("Follow Up Difficulty-"))
                {
                    _sControlID = s.Replace("Follow Up Difficulty-", "rblQdifficulty");

                    foreach (Control ctrl in panel.Controls)
                    {
                        if (ctrl is RadioButtonList)
                        {
                            RadioButtonList rbl = (RadioButtonList)ctrl;
                            try
                            {
                                if (rbl.ID == _sControlID)
                                {
                                    /* 
                                     0 - Able to do without any difficulty
                                     1 - Able to do with little difficulty
                                     2 - Able to do with moderate difficulty
                                     3 - Able to do with much difficulty
                                     4 - Unable to do
                                     5 - Not Applicable
                                     */
                                    if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToString() == "Able to do without any difficulty")
                                    {
                                        rbl.SelectedIndex = 0;
                                    }
                                    else if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToString() == "Able to do with little difficulty")
                                    {
                                        rbl.SelectedIndex = 1;
                                    }
                                    else if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToString() == "Able to do with moderate difficulty")
                                    {
                                        rbl.SelectedIndex = 2;
                                    }
                                    else if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToString() == "Able to do with much difficulty")
                                    {
                                        rbl.SelectedIndex = 3;
                                    }
                                    else if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToString() == "Unable to do")
                                    {
                                        rbl.SelectedIndex = 4;
                                    }
                                    else if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToString() == "Not Applicable")
                                    {
                                        rbl.SelectedIndex = 5;
                                    }
                                }

                            }
                            catch (Exception surveyEx)
                            {
                                Exception _tbilogerror = HandleTBIException(surveyEx, "OptimalFollowUp.aspx", "100027", "setUpRadioButtons");
                            }
                        }
                    }
                }
            }
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "RehabFollowUp.aspx", "100027", "setUpRadioButtons");
        }
    }
    /// <summary>
    /// Initialize/setup controls
    /// </summary>
    /// <param name="survey"></param>
    private void SetUpSurvey(SURVEY survey)
    {
        try
        {
            //check con first
            if (survey.SURVEY_RESULTs.Count > -1)
            {
                setUpRadioButtons(pnlBaselineDifficulty, survey);
              
                foreach (var sResult in survey.SURVEY_RESULTs)
                {

                    switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER)
                    {
                        case "Total Score":
                            if (!String.IsNullOrEmpty(sResult.RESULT_TEXT))
                            {
                                lblBasicActivitiesScore.Text = sResult.RESULT_TEXT;
                            }
                            break;
                        case "Survey Date":
                            if (!String.IsNullOrEmpty(sResult.RESULT_TEXT))
                            {
                                dpDate1.MaxDate=Convert.ToDateTime(sResult.RESULT_TEXT);
                            }
                            break;

                        default:
                            break;
                    }
                }
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "OptimalFollowUp.aspx", "100027", "SetUpSurvey()");
        }
    }// END SetUpSurvey
    /// <summary>
    /// Retrieve instrument title
    /// </summary>
    /// <param name="surveyID"></param>
    /// <returns></returns>
    private string GetInstrumentTitle(int surveyID)
    {
        string ret = String.Empty;

        try
        {
            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(surveyID).Title;
            if (instrumentTitle.Count > 0)
            {
                foreach (string titleLine in instrumentTitle)
                {
                    if (titleLine.Contains("PhD"))
                    {
                        ret = ret + "<small>" + titleLine + "</small>" + "<br \\>";
                    }
                    else
                    {
                        ret = ret + titleLine + "<br \\>";
                    }
                }
            }

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "OptimalFollowUp.aspx", "100027", "GetInstrumentTitle()");
            // Ignore error
        }
        return ret;
    }
    /// <summary>
    /// performs total calcuation
    /// </summary>
    private void calculateTotals()
    {
        #region calculate basic

        int basicScore = 0;

        foreach (Control ctrl in pnlBaselineDifficulty.Controls)
        {
            if (ctrl is RadioButtonList)
            {
                RadioButtonList rbl = (RadioButtonList)ctrl;

                for (int i = 0; i < ((RadioButtonList)ctrl).Items.Count-1; i++)
                {

                    if ((rbl.Items[i].Selected) && (i != 5))
                    {
                        try
                        {
                            basicScore += i + 1;
                        }
                        catch (Exception surveyEx)
                        {
                            Exception _tbilogerror = HandleTBIException(surveyEx, "OptimalFollowUp.aspx", "100027", "calculateTotals()- Baseline Difficulty");
                        }

                    }
                }
            }
        }

        lblBasicActivitiesScore.Text = basicScore.ToString();

        #endregion

    }
    //Replaces calls to GetChoicesByQuestionNumberandSurveyType
    private List<STD_QUESTION_CHOICE> GetQuestionChoices(string questionNumber)
    {
        return VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestionChoices(questionNumber);
    }
    private void SaveCheckAnswer(STD_QUESTION_CHOICE choice, List<string> answerList)
    {
        if (!IsNotAsked(choice.CHOICE_TEXT))
            answerList.Add(choice.STD_QUESTION_CHOICE_ID.ToString());
    }
    private void SaveDropDownListAnswers(Panel panel, SURVEY survey)
    {
        foreach (Control ctrl in panel.Controls)
        {
            if (ctrl is DropDownList)
            {
                DropDownList ddl = (DropDownList)ctrl;
                if (ddl.ID != "q24")
                {
                    for (int i = 0; i < ((DropDownList)ctrl).Items.Count-1; i++)
                    {
                        if (ddl.SelectedIndex == i)
                        {
                            _surveyResult = new SURVEY_RESULT();

                            try
                            {
                                // Add Question Living Arrangements
                                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(ddl.SelectedItem.Value);
                                _surveyResult.RESULT_TEXT = ddl.SelectedItem.Text;
                                survey.SURVEY_RESULTs.Add(_surveyResult);
                            }
                            catch (Exception surveyEx)
                            {
                                Exception _tbilogerror = HandleTBIException(surveyEx, "OptimalFollowUp.aspx", "100027", "SaveSurvey() - SaveRadBtnListAnswers");
                            }
                        }
                    }
                }
            }
        }
    }
    private void SaveRadBtnListAnswers(Panel panel, SURVEY survey)
    {
        foreach (Control ctrl in panel.Controls)
        {
            if (ctrl is RadioButtonList)
            {
                RadioButtonList rbl = (RadioButtonList)ctrl;

                for (int i = 0; i < ((RadioButtonList)ctrl).Items.Count; i++)
                {
                    if (rbl.Items[i].Selected)
                    {
                        _surveyResult = new SURVEY_RESULT();
                        try
                        {
                            // Add Question Living Arrangements
                            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rbl.Items[i].Value);
                            _surveyResult.RESULT_TEXT = rbl.Items[i].Text;
                            survey.SURVEY_RESULTs.Add(_surveyResult);
                        }
                        catch (Exception surveyEx)
                        {
                            Exception _tbilogerror = HandleTBIException(surveyEx, "OptimalFollowUp.aspx", "100027", "SaveSurvey() - SaveRadBtnListAnswers");
                        }
                    }
                }
            }
        }
    }
    private void SaveCheckListAnswers(Panel panel, SURVEY survey)
    {
        foreach (Control ctrl in panel.Controls)
        {
            if (ctrl is CheckBoxList)
            {
                CheckBoxList chbx = (CheckBoxList)ctrl;

                for (int i = 0; i < ((CheckBoxList)ctrl).Items.Count; i++)
                {
                    if (chbx.Items[i].Selected)
                    {
                        _surveyResult = new SURVEY_RESULT();
                        try
                        {
                            // Add Question Living Arrangements
                            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(chbx.Items[i].Value);
                            _surveyResult.RESULT_TEXT = chbx.Items[i].Text;
                            survey.SURVEY_RESULTs.Add(_surveyResult);
                        }
                        catch (Exception surveyEx)
                        {
                            Exception _tbilogerror = HandleTBIException(surveyEx, "OptimalFollowUp.aspx", "100027", "SaveSurvey() - SaveCheckListAnswers");
                        }
                    }
                }
            }
        }
    }
    private bool IsNotAsked(string s)
    {
        if (string.IsNullOrEmpty(s))
            return false;
        return s.IndexOf("not asked", StringComparison.OrdinalIgnoreCase) != -1;
    }
    #endregion
}
